/* ==========================================================
   WaSender Pro – script.js
   ========================================================== */

'use strict';

// ── CONSTANTE WHATSAPP ──
const WHATSAPP_NUMBER = '593960705007';
const WHATSAPP_MSG = encodeURIComponent('Hola, quiero comprar WaSender Pro por $15/año');

// ── PARTÍCULAS ──────────────────────────────────────────────
(function initParticles() {
  const canvas = document.getElementById('particles-canvas');
  if (!canvas) return;
  const ctx = canvas.getContext('2d');
  let W, H, particles = [], animId;
  const COUNT = 50;

  function resize() {
    W = canvas.width = window.innerWidth;
    H = canvas.height = window.innerHeight;
  }

  function createParticle() {
    return {
      x: Math.random() * W,
      y: Math.random() * H,
      r: Math.random() * 2.2 + 0.4,
      dx: (Math.random() - 0.5) * 0.35,
      dy: (Math.random() - 0.5) * 0.35,
      o: Math.random() * 0.5 + 0.08,
    };
  }

  function init() {
    particles = Array.from({ length: COUNT }, createParticle);
  }

  function draw() {
    ctx.clearRect(0, 0, W, H);
    particles.forEach(p => {
      ctx.beginPath();
      ctx.arc(p.x, p.y, p.r, 0, Math.PI * 2);
      ctx.fillStyle = `rgba(34,197,94,${p.o})`;
      ctx.fill();

      p.x += p.dx;
      p.y += p.dy;
      if (p.x < -10) p.x = W + 10;
      if (p.x > W + 10) p.x = -10;
      if (p.y < -10) p.y = H + 10;
      if (p.y > H + 10) p.y = -10;
    });

    // Líneas entre partículas cercanas
    for (let i = 0; i < particles.length; i++) {
      for (let j = i + 1; j < particles.length; j++) {
        const dx = particles[i].x - particles[j].x;
        const dy = particles[i].y - particles[j].y;
        const dist = Math.sqrt(dx * dx + dy * dy);
        if (dist < 130) {
          ctx.beginPath();
          ctx.moveTo(particles[i].x, particles[i].y);
          ctx.lineTo(particles[j].x, particles[j].y);
          ctx.strokeStyle = `rgba(34,197,94,${0.08 * (1 - dist / 130)})`;
          ctx.lineWidth = 0.8;
          ctx.stroke();
        }
      }
    }
    animId = requestAnimationFrame(draw);
  }

  window.addEventListener('resize', () => { resize(); init(); });
  resize();
  init();
  draw();
})();

// ── NAVBAR STICKY ───────────────────────────────────────────
(function initNavbar() {
  const navbar = document.getElementById('navbar');
  if (!navbar) return;
  function onScroll() {
    navbar.classList.toggle('scrolled', window.scrollY > 30);
  }
  window.addEventListener('scroll', onScroll, { passive: true });
  onScroll();
})();

// ── HAMBURGER / MOBILE MENU ─────────────────────────────────
(function initMobileMenu() {
  const hamburger = document.getElementById('hamburger');
  const mobileMenu = document.getElementById('mobile-menu');
  if (!hamburger || !mobileMenu) return;

  hamburger.addEventListener('click', () => {
    const open = mobileMenu.classList.toggle('open');
    hamburger.classList.toggle('open', open);
    hamburger.setAttribute('aria-expanded', open);
    document.body.style.overflow = open ? 'hidden' : '';
  });

  // Cierra al hacer clic en un link
  mobileMenu.querySelectorAll('a').forEach(link => {
    link.addEventListener('click', () => {
      mobileMenu.classList.remove('open');
      hamburger.classList.remove('open');
      hamburger.setAttribute('aria-expanded', 'false');
      document.body.style.overflow = '';
    });
  });
})();

// ── SMOOTH SCROLL ───────────────────────────────────────────
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
  anchor.addEventListener('click', function (e) {
    const targetId = this.getAttribute('href');
    if (targetId === '#') return;
    const target = document.querySelector(targetId);
    if (!target) return;
    e.preventDefault();
    target.scrollIntoView({ behavior: 'smooth' });
  });
});

// ── INTERSECTION OBSERVER – REVEAL ─────────────────────────
(function initReveal() {
  // Add reveal-ready so CSS hides elements — only after DOM loads
  document.body.classList.add('reveal-ready');

  const els = document.querySelectorAll('.reveal');
  if (!els.length) return;

  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.classList.add('visible');
      }
    });
  }, { threshold: 0.1, rootMargin: '0px 0px -30px 0px' });

  els.forEach(el => observer.observe(el));
})();

// ── CONTADORES ANIMADOS ─────────────────────────────────────
(function initCounters() {
  const counters = document.querySelectorAll('.metric-num[data-target]');
  if (!counters.length) return;

  function animateCounter(el) {
    const target = +el.dataset.target;
    const suffix = el.dataset.suffix || '';
    const duration = 1800;
    const step = duration / 60;
    let current = 0;
    const increment = target / (duration / (1000 / 60));

    function update() {
      current = Math.min(current + increment, target);
      el.textContent = Math.floor(current).toLocaleString('es') + suffix;
      if (current < target) requestAnimationFrame(update);
    }
    requestAnimationFrame(update);
  }

  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting && !entry.target.dataset.counted) {
        entry.target.dataset.counted = '1';
        animateCounter(entry.target);
        observer.unobserve(entry.target);
      }
    });
  }, { threshold: 0.5 });

  counters.forEach(c => observer.observe(c));
})();

// ── FLIP CARDS 3D ───────────────────────────────────────────
(function initFlipCards() {
  const cards = document.querySelectorAll('.flip-card');
  const isTouchDevice = () => window.matchMedia('(hover: none)').matches;

  cards.forEach(card => {
    // TAP en móvil
    card.addEventListener('click', () => {
      if (isTouchDevice()) {
        card.classList.toggle('flipped');
      }
    });
    // Teclado accesibilidad
    card.addEventListener('keydown', e => {
      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();
        card.classList.toggle('flipped');
      }
    });
  });
})();

// ── FAQ ACCORDION ───────────────────────────────────────────
(function initFAQ() {
  const items = document.querySelectorAll('.faq-item');

  items.forEach(item => {
    const btn = item.querySelector('.faq-question');
    const answer = item.querySelector('.faq-answer');
    if (!btn || !answer) return;

    btn.addEventListener('click', () => {
      const isOpen = answer.classList.contains('open');

      // Cierra todos
      items.forEach(i => {
        const a = i.querySelector('.faq-answer');
        const b = i.querySelector('.faq-question');
        if (a) a.classList.remove('open');
        if (b) b.setAttribute('aria-expanded', 'false');
        i.style.borderColor = '';
      });

      // Abre el actual si estaba cerrado
      if (!isOpen) {
        answer.classList.add('open');
        btn.setAttribute('aria-expanded', 'true');
        item.style.borderColor = 'rgba(34,197,94,0.4)';
      }
    });
  });
})();

// ── SCROLL CUE FADE ─────────────────────────────────────────
(function initScrollCue() {
  const cue = document.getElementById('scroll-cue');
  if (!cue) return;
  window.addEventListener('scroll', () => {
    cue.style.opacity = window.scrollY > 60 ? '0' : '1';
  }, { passive: true });
})();

// ── EFECTO PARALLAX SUTIL EN HERO GLOW ─────────────────────
(function initParallax() {
  const glow = document.querySelector('.hero-bg-glow');
  if (!glow) return;
  window.addEventListener('mousemove', e => {
    const x = (e.clientX / window.innerWidth - 0.5) * 30;
    const y = (e.clientY / window.innerHeight - 0.5) * 20;
    glow.style.transform = `translateX(calc(-50% + ${x}px)) translateY(${y}px)`;
  });
})();

// ── ACTIVE NAV LINK AL SCROLL ──────────────────────────────
(function initActiveNavLink() {
  const sections = document.querySelectorAll('section[id]');
  const navLinks = document.querySelectorAll('.nav-link');

  const io = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        navLinks.forEach(l => l.classList.remove('active'));
        const active = document.querySelector(`.nav-link[href="#${entry.target.id}"]`);
        if (active) active.classList.add('active');
      }
    });
  }, { threshold: 0.4 });

  sections.forEach(s => io.observe(s));
})();

// ── NAV LINK ACTIVE STYLE (dinámico) ──────────────────────
(function injectActiveStyle() {
  const style = document.createElement('style');
  style.textContent = `.nav-link.active { color: var(--primary-400) !important; }`;
  document.head.appendChild(style);
})();
